/*
 * Decompiled with CFR 0.152.
 */
package mhzd.net.autoclick.network;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import mhzd.net.autoclick.network.NetCodec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetHandlerRoot {
    private static final Logger log = LogManager.getLogger();
    private final NetCodec codec;
    private final Map<Key, ServerPathHandler> serverPathMap = new HashMap<Key, ServerPathHandler>();
    private final Map<Key, ClientPathHandler> clientPathMap = new HashMap<Key, ClientPathHandler>();

    public NetHandlerRoot(NetCodec codec) {
        this.codec = codec;
    }

    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        FMLProxyPacket packet = event.getPacket();
        ByteBuf payload = packet.payload();
        String path = this.codec.decode(payload, String.class);
        Key key = new Key(packet.channel(), path);
        ClientPathHandler handlerPath = this.clientPathMap.get(key);
        if (handlerPath == null) {
            log.warn("receive unregister message. side=client, channel={} path={}", (Object)packet.channel(), (Object)path);
            return;
        }
        handlerPath.onMessage((NetHandlerPlayClient)event.getHandler(), payload);
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        FMLProxyPacket packet = event.getPacket();
        ByteBuf payload = packet.payload();
        String path = this.codec.decode(payload, String.class);
        Key key = new Key(packet.channel(), path);
        ServerPathHandler handlerPath = this.serverPathMap.get(key);
        if (handlerPath == null) {
            log.warn("receive unregister message. side=server, channel={} path={}", (Object)packet.channel(), (Object)path);
            return;
        }
        handlerPath.onMessage((NetHandlerPlayServer)event.getHandler(), payload);
    }

    public void registerMethodClient(Method method, @Nullable Object object, String channel, String path) {
        Class<?>[] types = method.getParameterTypes();
        Key key = new Key(channel, path);
        if (this.clientPathMap.containsKey(key)) {
            return;
        }
        ArrayList<Function<ByteBuf, Object>> parametersDecode = new ArrayList<Function<ByteBuf, Object>>(types.length);
        for (Class<?> type : types) {
            Function<ByteBuf, Object> decode = this.codec.findDecode(type);
            if (decode == null) {
                throw new IllegalArgumentException(method + " can't find decode of " + type);
            }
            parametersDecode.add(decode);
        }
        this.clientPathMap.put(key, new ClientPathHandler(method, object, parametersDecode));
    }

    public void registerMethodServer(Method method, @Nullable Object object, String channel, String path) {
        Class<?>[] types = method.getParameterTypes();
        Key key = new Key(channel, path);
        if (this.serverPathMap.containsKey(key)) {
            return;
        }
        ArrayList<Function<ByteBuf, Object>> parametersDecode = new ArrayList<Function<ByteBuf, Object>>(types.length);
        for (Class<?> type : types) {
            if (type.equals(EntityPlayerMP.class)) {
                parametersDecode.add(ServerPathHandler.PLAYER_ARGUMENT);
                continue;
            }
            Function<ByteBuf, Object> decode = this.codec.findDecode(type);
            if (decode == null) {
                throw new IllegalArgumentException(method + " can't find decode of " + type);
            }
            parametersDecode.add(decode);
        }
        this.serverPathMap.put(key, new ServerPathHandler(method, object, parametersDecode));
    }

    private static class ServerPathHandler {
        private static final Function<ByteBuf, Object> PLAYER_ARGUMENT = buf -> null;
        private final Method method;
        @Nullable
        private final Object object;
        private final List<Function<ByteBuf, Object>> argumentDecodes;

        ServerPathHandler(Method method, @Nullable Object object, List<Function<ByteBuf, Object>> argumentDecodes) {
            this.object = object;
            this.method = method;
            this.argumentDecodes = argumentDecodes;
        }

        void onMessage(NetHandlerPlayServer net, ByteBuf buf) {
            Object[] arguments = new Object[this.argumentDecodes.size()];
            int i = 0;
            for (Function<ByteBuf, Object> decode : this.argumentDecodes) {
                arguments[i] = decode == PLAYER_ARGUMENT ? net.field_147369_b : decode.apply(buf);
                ++i;
            }
            net.field_147369_b.func_71121_q().func_152344_a(() -> {
                try {
                    this.method.invoke(this.object, arguments);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private static class ClientPathHandler {
        private final Method method;
        @Nullable
        private final Object object;
        private final List<Function<ByteBuf, Object>> argumentDecodes;

        ClientPathHandler(Method method, @Nullable Object object, List<Function<ByteBuf, Object>> argumentDecodes) {
            this.object = object;
            this.method = method;
            this.argumentDecodes = argumentDecodes;
        }

        void onMessage(NetHandlerPlayClient net, ByteBuf buf) {
            Object[] arguments = new Object[this.argumentDecodes.size()];
            int i = 0;
            for (Function<ByteBuf, Object> decode : this.argumentDecodes) {
                arguments[i] = decode.apply(buf);
                ++i;
            }
            Minecraft.func_71410_x().func_152344_a(() -> {
                try {
                    this.method.invoke(this.object, arguments);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private static class Key {
        private final String channel;
        private final String path;

        private Key(String channel, String path) {
            this.channel = channel;
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.channel, key.channel) && Objects.equals(this.path, key.path);
        }

        public int hashCode() {
            return Objects.hash(this.channel, this.path);
        }
    }
}

